/*
 * Decompiled with CFR 0.152.
 */
package com.service.invoice.commission;

import com.dao.HolooSettingsDao;
import com.dto.InvoiceDto;
import com.dto.PaymentDetailDto;
import com.service.invoice.commission.BaseMidMenCommission;
import com.service.invoice.commission.GenericMidMenCommission;
import com.service.invoice.commission.MGroupMidMenCommission;
import com.service.invoice.commission.ProductMidMenCommission;
import com.service.invoice.commission.SGroupMidMenCommission;
import com.utility.DbLogin;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.lang.NonNull;

public class CommissionCalculator {
    private final DbLogin dbLogin;
    private final InvoiceDto.InvoiceInfo invoice;
    private BaseMidMenCommission calculation;

    public CommissionCalculator(DbLogin dbLogin, InvoiceDto.InvoiceInfo invoice) {
        this.dbLogin = dbLogin;
        this.invoice = invoice;
        this.setStrategy();
    }

    private void setStrategy() {
        HolooSettingsDao settingsDao = new HolooSettingsDao(this.dbLogin.getDbConnection());
        Map result = settingsDao.getMapMultiple(rowSet -> rowSet.getBoolean("Boolean"), "[Boolean]", "0", this.dbLogin.getLogin(), new String[]{"PorsantSatri", "MGroupPorsant", "SGroupPorsant", "ArticlePorsant", "NoPorsant"});
        if (!result.getOrDefault("PorsantSatri", false).booleanValue()) {
            return;
        }
        this.calculation = result.getOrDefault("NoPorsant", false) != false ? new GenericMidMenCommission(this.dbLogin, this.invoice) : (result.getOrDefault("MGroupPorsant", false) != false ? new MGroupMidMenCommission(this.dbLogin, this.invoice) : (result.getOrDefault("SGroupPorsant", false) != false ? new SGroupMidMenCommission(this.dbLogin, this.invoice) : (result.getOrDefault("ArticlePorsant", false) != false ? new ProductMidMenCommission(this.dbLogin, this.invoice) : new GenericMidMenCommission(this.dbLogin, this.invoice))));
    }

    public void calculateCommission() {
        if (this.calculation == null) {
            return;
        }
        this.calculation.calculateCommission();
    }

    public void insertFConnect() {
        if (this.calculation == null) {
            return;
        }
        this.calculation.insertFConnect();
    }

    @NonNull
    public List<PaymentDetailDto> getCommissionSndListData() {
        if (this.calculation == null) {
            return new ArrayList<PaymentDetailDto>();
        }
        return this.calculation.getCommissionSndListData();
    }

    public void updateFactArt() {
        if (this.calculation == null) {
            return;
        }
        this.calculation.updateFactArt();
    }
}

